const OpenAI = require('openai');

const openai = new OpenAI({
  apiKey: process.env.OPENAI_API_KEY
});

const prompts = {
  instagram_caption: (data) => `Create an engaging Instagram caption for a ${data.niche || 'general'} account. 
Topic: ${data.prompt}
Tone: ${data.tone || 'professional'}
Include relevant emojis and 3-5 hashtags.`,

  tiktok_idea: (data) => `Generate a creative TikTok video idea for a ${data.niche || 'general'} creator.
Topic: ${data.prompt}
Tone: ${data.tone || 'fun and engaging'}
Include: Hook, main content idea, and call-to-action.`,

  reel_script: (data) => `Write a 30-second Instagram Reel script for ${data.niche || 'general'} content.
Topic: ${data.prompt}
Tone: ${data.tone || 'energetic'}
Format: Hook (first 3 seconds), Main points (with timestamps), CTA`,

  content_plan: (data) => `Create a 30-day social media content plan for a ${data.niche || 'general'} account.
Focus area: ${data.prompt}
Platform: ${data.platform || 'Instagram'}
Provide: Daily post ideas with content types (Reels, carousel, static post, etc.)`,

  quote_hook: (data) => `Generate 5 attention-grabbing hooks or quotes for ${data.niche || 'general'} content.
Topic: ${data.prompt}
Tone: ${data.tone || 'inspirational'}
Make them short, punchy, and scroll-stopping.`
};

async function generateContent(type, data) {
  try {
    const systemPrompt = prompts[type];
    
    if (!systemPrompt) {
      throw new Error('Invalid content type');
    }
    
    const response = await openai.chat.completions.create({
      model: 'gpt-3.5-turbo',
      messages: [
        {
          role: 'system',
          content: 'You are an expert social media content creator and strategist.'
        },
        {
          role: 'user',
          content: systemPrompt(data)
        }
      ],
      temperature: 0.8,
      max_tokens: 1000
    });
    
    return response.choices[0].message.content;
  } catch (error) {
    console.error('OpenAI API error:', error);
    throw new Error('Failed to generate content');
  }
}

module.exports = {
  generateContent
};

