// Authentication utilities

// Check if user is authenticated
async function checkAuth() {
  try {
    const response = await $.ajax({
      url: '/api/auth/me',
      method: 'GET'
    });
    return response.user;
  } catch (error) {
    return null;
  }
}

// Redirect to login if not authenticated
async function requireAuth() {
  const user = await checkAuth();
  if (!user) {
    window.location.href = '/login';
    return false;
  }
  return user;
}

// Redirect to dashboard if already authenticated
async function redirectIfAuthenticated() {
  const user = await checkAuth();
  if (user) {
    window.location.href = '/dashboard';
  }
}

// Logout function
async function logout() {
  try {
    await $.ajax({
      url: '/api/auth/logout',
      method: 'POST'
    });
    window.location.href = '/';
  } catch (error) {
    showToast('Failed to logout', 'error');
  }
}

// Update navbar with user info
async function updateNavbar() {
  const user = await checkAuth();
  const authButtons = $('#auth-buttons');
  
  if (user) {
    authButtons.html(`
      <a href="/dashboard" class="text-gray-700 hover:text-indigo-600 px-3 py-2 font-medium">Dashboard</a>
      <button onclick="logout()" class="text-gray-700 hover:text-indigo-600 px-3 py-2 font-medium">Logout</button>
    `);
  } else {
    authButtons.html(`
      <a href="/login" class="text-gray-700 hover:text-indigo-600 px-3 py-2 font-medium">Login</a>
      <a href="/signup" class="btn-gradient text-white px-6 py-2 rounded-lg font-medium">Sign Up</a>
    `);
  }
}

